/** @file   GuardianTankController.h
 * @brief   Declaration of GuardianTankController class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/03/29 22:25:48 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_GUARDIANTANKCONTROLLER_H
#define H_WWW_GUARDIANTANKCONTROLLER_H

#include "WaypointController.h"

namespace WeWantWar {

/** @class  GuardianTankController
 * @brief   Controls the GuardianTank
 * @author  Tomi Lamminsaari
 *
 */
class GuardianTankController : public WaypointController
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  GuardianTankController( GameObject* aObject );

  /** Destructor
   */
  virtual ~GuardianTankController();

private:
  GuardianTankController( const GuardianTankController& aAnother );
  GuardianTankController& operator= ( const GuardianTankController& aAnother );
public:

  ///
  /// Inherited methods
  /// =================

  /** From BaseController
   */
  virtual void update();

  ///
  /// New public methods
  /// ==================

  /** Sets the attacking distance.
   * @param   aRange            The distance where to attack
   */
  void setAttackRange( float aRange );

  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================

  bool canSeeTarget() const;

protected:
  ///
  /// Data members
  /// ============

  /** Attacking range in pixels */
  float iAttackRange;
};

};  // end of namespace

#endif
